package gameCanvasUtil;



/** 時間の管理等を行うためのクラスです。
 * 
 * 主にFPSの管理をしてます<br />
 * <br />
 * 見る人が見たらアホな実装ですが、
 * System.currentTimeMillis　の精度が悪いので仕方なく・・・
 */
public class timerWaitManager {
	//前の時間
	private long t_prev=0;
	// 前一秒のFPS,FPS用のカウント，一フレームあたりの待ち時間
	private int fps,fps_temp,wait_time;
	
	//理想のFPS
	private int conf_fps;
	
	/** プライベートコンストラクタ 
	 */
	private void timerWaitManager(){
	}
	
	private static timerWaitManager _this=null;
	
	/** シングルトン
	 * @return オブジェクトを返す
	 */
	public static timerWaitManager getInstance(){
		if(_this==null)
			_this = new timerWaitManager();
		return _this;
	}
	
	/** 設定
	 * @param conf_fps FPSの指定を行う
	 */
	public void init(int conf_fps){
		this.conf_fps = conf_fps;
		this.wait_time = 1000/conf_fps;
	}
	
	/** 少し待たせる
	 * @return 実行中のFPS
	 */
	public int Wait(){
		long time,tmp;
		
		time = System.currentTimeMillis();
		fps_temp++;
		if(t_prev/1000 != time/1000){
			fps = fps_temp;
			fps_temp = 0;
			if(fps>conf_fps+1){
				wait_time++;
			}else if(fps<conf_fps-1){
				wait_time--;
			}
			if(fps>conf_fps+ conf_fps/3){
				wait_time = (fps - wait_time)/3 + wait_time;
			}
		}
		tmp = time - t_prev;
		t_prev = time;
		if(tmp==0){tmp=1;}
		this.sleep();
		return fps;
		//return 1000/(int)(tmp);
	}
	/** しばしの間スリープする
	 */
	private void sleep(){
		try{
			if(wait_time>0)
				Thread.sleep(wait_time);
		}catch(InterruptedException e){
			e.printStackTrace();
		}
	}
	
	/** FPSを調べる
	 * @return FPSを返す。
	 */
	public int getFps(){
		return fps;
	}
}
